/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.ApplicationException;
import aurora.plugin.sap.sync.idoc.IDocFile;
import aurora.plugin.sap.sync.idoc.IDocServer;
import aurora.plugin.sap.sync.idoc.IdocType;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;

public class IDocXMLParser
extends Thread {
    public static final String SYNC = "sync";
    public IDocServer iDocServer;
    public List errorIdocTypes = new LinkedList();
    public int header_id;
    public IdocType idocType;

    public IDocXMLParser(IDocServer iDocServer) {
        this.iDocServer = iDocServer;
    }

    public void run() {
        while (!this.isFinished()) {
            String errorMessage;
            this.idocType = null;
            this.header_id = -1;
            IDocFile file = this.iDocServer.getIdocFile();
            if (file == null) continue;
            try {
                this.header_id = this.iDocServer.getDbUtil().existHeaders(file.getIdocId());
                this.insertInterface(file);
            }
            catch (Throwable e) {
                try {
                    this.iDocServer.log(e);
                    if (this.idocType != null) {
                        this.errorIdocTypes.add(this.idocType);
                    }
                    errorMessage = "interface failed";
                    this.iDocServer.log("updateIdocStatus for idoc:" + file.getIdocId() + " " + errorMessage);
                    this.iDocServer.getDbUtil().updateIdocsStatus(file.getIdocId(), errorMessage);
                }
                catch (Throwable e1) {
                    this.iDocServer.log(e1);
                }
                continue;
            }
            try {
                this.iDocServer.log("insertMiddleTables for idoc:" + file.getIdocId());
                this.insertMiddleTables(file);
            }
            catch (Throwable e) {
                this.iDocServer.log(e);
                try {
                    errorMessage = "middle failed";
                    this.iDocServer.log("updateIdocStatus for idoc:" + file.getIdocId() + " " + errorMessage);
                    this.iDocServer.getDbUtil().updateIdocStatus(this.header_id, file.getIdocId(), errorMessage);
                }
                catch (SQLException e1) {
                    this.iDocServer.log(e1);
                }
                continue;
            }
            try {
                this.iDocServer.log("insertFormalTables for idoc:" + file.getIdocId());
                this.insertFormalTables(file);
            }
            catch (Throwable e) {
                this.iDocServer.log(e);
                try {
                    errorMessage = "formal failed";
                    this.iDocServer.log("updateIdocStatus for idoc:" + file.getIdocId() + " " + errorMessage);
                    this.iDocServer.getDbUtil().updateIdocStatus(this.header_id, file.getIdocId(), errorMessage);
                }
                catch (SQLException e1) {
                    this.iDocServer.log(e1);
                }
                continue;
            }
            this.iDocServer.log("idoc:" + file.getIdocId() + " execute successful !");
        }
    }

    private void insertInterface(IDocFile file) throws ApplicationException {
        File deleteFile;
        block18: {
            try {
                if (this.header_id != -1) break block18;
                this.iDocServer.log("parser " + file.getPath() + " file");
                CompositeLoader loader = new CompositeLoader();
                CompositeMap iDocData = loader.loadByFile(file.getPath());
                CompositeMap idoc_node = iDocData.getChild("IDOC");
                if (idoc_node == null || idoc_node.getChildIterator() == null || idoc_node.getChilds().size() < 2) {
                    return;
                }
                try {
                    CompositeMap control_node = (CompositeMap)idoc_node.getChilds().get(0);
                    this.idocType = this.iDocServer.getDbUtil().getIdocType(control_node);
                    if (this.isStop()) {
                        throw new ApplicationException("This idocType:" + this.idocType + " has error before");
                    }
                    this.iDocServer.getDbUtil().getConnection().setAutoCommit(false);
                    this.header_id = this.iDocServer.getDbUtil().registerInterfaceHeader(file.getIdocId(), control_node);
                    this.iDocServer.getDbUtil().updateIdocInfo(file.getIdocId(), control_node);
                    int i = 1;
                    while (i < idoc_node.getChilds().size()) {
                        CompositeMap content_node = (CompositeMap)idoc_node.getChilds().get(i);
                        this.iDocServer.getDbUtil().registerInterfaceLine(this.header_id, content_node);
                        ++i;
                    }
                    this.iDocServer.getDbUtil().getConnection().commit();
                    this.iDocServer.getDbUtil().getConnection().setAutoCommit(true);
                }
                catch (IOException e) {
                    throw new ApplicationException(e);
                }
                catch (SAXException e) {
                    throw new ApplicationException(e);
                }
                catch (SQLException e) {
                    throw new ApplicationException(e);
                }
            }
            finally {
                try {
                    this.iDocServer.getDbUtil().getConnection().rollback();
                    this.iDocServer.getDbUtil().getConnection().setAutoCommit(true);
                }
                catch (SQLException e) {
                    this.iDocServer.log(e);
                }
            }
        }
        if (this.iDocServer.isDeleteImmediately() && (deleteFile = new File(file.getPath())).exists()) {
            this.iDocServer.log("delete file " + file.getPath() + " " + deleteFile.delete());
        }
    }

    private void insertMiddleTables(IDocFile file) throws ApplicationException, SQLException {
        String executePkg = this.iDocServer.getDbUtil().getMiddleExecutePkg(file.getIdocId());
        String errorMessage = this.iDocServer.getDbUtil().executePkg(executePkg, this.header_id);
        if (errorMessage != null && !"".equals(errorMessage)) {
            throw new ApplicationException("execute middle Pkg " + executePkg + " failed:" + errorMessage);
        }
        this.iDocServer.getDbUtil().updateIdocStatus(this.header_id, file.getIdocId(), "middle");
    }

    private void insertFormalTables(IDocFile file) throws SQLException, ApplicationException {
        String executePkg = this.iDocServer.getDbUtil().getFormalExecutePkg(file.getIdocId());
        String errorMessage = this.iDocServer.getDbUtil().executePkg(executePkg, this.header_id);
        if (errorMessage != null && !"".equals(errorMessage)) {
            throw new ApplicationException("execute Formal Pkg " + executePkg + " failed:" + errorMessage);
        }
        this.iDocServer.getDbUtil().updateIdocStatus(this.header_id, file.getIdocId(), "done");
    }

    public boolean isFinished() {
        return this.iDocServer.isShutDown();
    }

    private boolean isStop() throws SQLException, ApplicationException {
        String handleModel = this.iDocServer.getDbUtil().getHandleModel(this.idocType.getIdoctyp(), this.idocType.getCimtyp());
        return SYNC.equals(handleModel) && this.errorIdocTypes.contains(this.idocType);
    }
}

