/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.config.CheckBoxConfig;
import aurora.presentation.component.std.config.ComboBoxConfig;
import aurora.presentation.component.std.config.ComponentConfig;
import aurora.presentation.component.std.config.DatePickerConfig;
import aurora.presentation.component.std.config.GridColumnConfig;
import aurora.presentation.component.std.config.GridConfig;
import aurora.presentation.component.std.config.LovConfig;
import aurora.presentation.component.std.config.NumberFieldConfig;
import aurora.presentation.component.std.config.TextFieldConfig;
import aurora.service.ServiceContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.composite.TypedHashMap;
import uncertain.event.Configuration;
import uncertain.proc.IFeature;
import uncertain.proc.ProcedureRunner;

public class AutoGrid
implements IFeature {
    private static final String PROPERTITY_MODEL = "model";
    IModelFactory mFactory;
    CompositeMap view;

    public AutoGrid(IModelFactory factory) {
        this.mFactory = factory;
    }

    public int onCreateView(ProcedureRunner runner) throws IOException {
        ServiceContext sc = ServiceContext.createServiceContext(runner.getContext());
        CompositeMap model = sc.getModel();
        CompositeMap gridView = this.processColumns(model);
        gridView = this.processEditors(gridView);
        this.view.getParent().replaceChild(this.view, gridView);
        return 0;
    }

    private CompositeMap processEditors(CompositeMap gv) throws IOException {
        GridConfig grid = GridConfig.getInstance(gv);
        CompositeMap columns = grid.getColumns();
        if (columns != null) {
            List list = columns.getChilds();
            for (CompositeMap column : list) {
                ComponentConfig editor;
                GridColumnConfig cf = GridColumnConfig.getInstance(column);
                String eid = cf.getEditor();
                if (eid != null && !"".equals(eid) || (editor = this.getEditor(column)) == null) continue;
                grid.addEditor(editor);
                cf.setEditor(editor.getId());
                column.getParent().replaceChild(column, cf.getObjectContext());
            }
        }
        CompositeMap gridView = grid.getObjectContext();
        return gridView;
    }

    private ComponentConfig getEditor(CompositeMap column) {
        String type = column.getString("editortype", "");
        if ("".equals(type)) {
            return null;
        }
        if ("checkbox".equalsIgnoreCase(type)) {
            CheckBoxConfig checkbox = CheckBoxConfig.getInstance();
            checkbox.setId(IDGenerator.getInstance().generate());
            return checkbox;
        }
        if ("textfield".equalsIgnoreCase(type)) {
            TextFieldConfig textfield = TextFieldConfig.getInstance();
            textfield.setId(IDGenerator.getInstance().generate());
            return textfield;
        }
        if ("datepicker".equalsIgnoreCase(type)) {
            DatePickerConfig datepicker = DatePickerConfig.getInstance();
            datepicker.setId(IDGenerator.getInstance().generate());
            return datepicker;
        }
        if ("numberfield".equalsIgnoreCase(type)) {
            NumberFieldConfig numberfield = NumberFieldConfig.getInstance();
            numberfield.setId(IDGenerator.getInstance().generate());
            return numberfield;
        }
        if ("lov".equalsIgnoreCase(type)) {
            LovConfig lov = LovConfig.getInstance();
            lov.setId(IDGenerator.getInstance().generate());
            return lov;
        }
        if ("combobox".equalsIgnoreCase(type)) {
            ComboBoxConfig combo = ComboBoxConfig.getInstance();
            combo.setId(IDGenerator.getInstance().generate());
            return combo;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private CompositeMap processColumns(CompositeMap model) throws IOException {
        CompositeMap columns;
        Object column;
        GridConfig grid = GridConfig.getInstance(this.view);
        ArrayList<Object> bmColumns = new ArrayList<Object>();
        String href = this.view.getString(PROPERTITY_MODEL, "");
        if (!"".equals(href)) {
            void var8_12;
            href = TextParser.parse(href, model);
            BusinessModel bm = null;
            try {
                bm = this.mFactory.getModelForRead(href);
            }
            catch (Exception e) {
                bm = this.mFactory.getModelForRead(href, "xml");
            }
            Field[] fields = bm.getFields();
            int fl = fields.length;
            boolean bl = false;
            while (var8_12 < fl) {
                Field field = fields[var8_12];
                if (field.isForDisplay()) {
                    column = GridColumnConfig.getInstance(field.getObjectContext());
                    ((ComponentConfig)column).setWidth(field.getDisplayWidth());
                    ((GridColumnConfig)column).setAlign(field.getDisplayAlign());
                    if (field.isDateType() && "".equals(((GridColumnConfig)column).getRenderer())) {
                        ((GridColumnConfig)column).setRenderer("Aurora.formatDate");
                    }
                    bmColumns.add(column);
                }
                ++var8_12;
            }
        }
        if ((columns = this.view.getChild("columns")) != null) {
            List cls = columns.getChilds();
            for (CompositeMap compositeMap : cls) {
                boolean defined = false;
                for (GridColumnConfig gridColumnConfig : bmColumns) {
                    String griddataIndex;
                    String bmDataIndex = gridColumnConfig.getName();
                    if (!bmDataIndex.equals(griddataIndex = compositeMap.getString("name"))) continue;
                    defined = true;
                    gridColumnConfig.getObjectContext().copy(compositeMap);
                    break;
                }
                if (defined) continue;
                GridColumnConfig gridColumnConfig = GridColumnConfig.getInstance(compositeMap);
                bmColumns.add(gridColumnConfig);
            }
        }
        CompositeMap viewColumns = new CompositeMap("columns");
        for (GridColumnConfig gridColumnConfig : bmColumns) {
            String dataType = gridColumnConfig.getString("datatype");
            column = gridColumnConfig.getObjectContext();
            if (dataType != null) {
                if ("java.lang.Double".equalsIgnoreCase(dataType)) {
                    ((TypedHashMap)column).putString("align", "right");
                    ((TypedHashMap)column).putString("renderer", "Aurora.formatMoney");
                } else if ("java.lang.Long".equalsIgnoreCase(dataType)) {
                    ((TypedHashMap)column).putString("align", "right");
                    ((TypedHashMap)column).putString("renderer", "Aurora.formatNumber");
                }
            }
            viewColumns.addChild((CompositeMap)column);
        }
        grid.getObjectContext().replaceChild(grid.getColumns(), viewColumns);
        CompositeMap compositeMap = grid.getObjectContext();
        return compositeMap;
    }

    public int attachTo(CompositeMap v, Configuration procConfig) {
        this.view = v;
        return 0;
    }
}

