/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.BmBuiltinExceptionFactory;
import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.profile.IDatabaseProfile;
import aurora.database.profile.ISqlBuilderRegistry;
import aurora.database.service.BusinessModelServiceContext;
import aurora.database.sql.ConditionList;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.RawSqlExpression;
import aurora.database.sql.UpdateStatement;
import aurora.database.sql.UpdateTarget;

public abstract class AbstractSqlCreator {
    IModelFactory modelFactory;
    IDatabaseFactory mDatabaseFactory;

    public AbstractSqlCreator(IModelFactory model_fact, IDatabaseFactory db_fact) {
        this.modelFactory = model_fact;
        this.mDatabaseFactory = db_fact;
    }

    public ISqlBuilderRegistry getSqlBuilderRegistry(BusinessModel model) {
        String databaseType = model.getDatabaseType();
        if (databaseType != null) {
            IDatabaseProfile prof = this.mDatabaseFactory.getDatabaseProfile(databaseType);
            if (prof == null) {
                throw BmBuiltinExceptionFactory.createUnknownDatabaseType(databaseType, model.getObjectContext());
            }
            return prof.getSqlBuilderRegistry();
        }
        return this.mDatabaseFactory.getDefaultDatabaseProfile().getSqlBuilderRegistry();
    }

    protected StringBuffer createSql(ISqlStatement stmt, BusinessModelServiceContext context) {
        ISqlBuilderRegistry reg = this.getSqlBuilderRegistry(context.getBusinessModel());
        String str = reg.getSql(stmt);
        if (str == null) {
            throw new IllegalStateException("Can't get proper bulider for sql statement " + stmt.getClass().getName());
        }
        StringBuffer sql = new StringBuffer(str);
        return sql;
    }

    protected void doCreateSql(String type, ISqlStatement stmt, BusinessModelServiceContext context) {
        StringBuffer sql = this.createSql(stmt, context);
        context.setSqlString(sql);
    }

    public static void addPrimaryKeyQuery(BusinessModel model, UpdateStatement stmt) {
        ConditionList where = stmt.getWhereClause();
        Field[] fields = model.getPrimaryKeyFields();
        UpdateTarget table = stmt.getUpdateTarget();
        int i = 0;
        while (i < fields.length) {
            where.addEqualExpression(table.createField(fields[i].getPhysicalName()), new RawSqlExpression(fields[i].getUpdateExpression()));
            ++i;
        }
    }

    public IModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public void setModelFactory(IModelFactory modelFactory) {
        this.modelFactory = modelFactory;
    }
}

