/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.IBusinessModelAccessChecker;
import java.util.Set;

public class DefaultAccessChecker
implements IBusinessModelAccessChecker {
    public static final IBusinessModelAccessChecker ALWAYS_ALLOW = new ConstantChecker(true);
    public static final IBusinessModelAccessChecker ALWAYS_DENY = new ConstantChecker(false);
    Set mEnabledOperations;

    public DefaultAccessChecker(Set enabledOperations) {
        this.mEnabledOperations = enabledOperations;
    }

    public boolean canPerformOperation(String operation) {
        return this.mEnabledOperations.contains(operation);
    }

    public static class ConstantChecker
    implements IBusinessModelAccessChecker {
        boolean result;

        public ConstantChecker(boolean b) {
            this.result = b;
        }

        public boolean canPerformOperation(String operation) {
            return this.result;
        }
    }
}

