/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.service;

import aurora.bm.BusinessModel;
import aurora.database.DBUtil;
import aurora.database.FetchDescriptor;
import aurora.database.IResultSetConsumer;
import aurora.database.ParsedSql;
import aurora.database.ResultSetLoader;
import aurora.database.SqlRunner;
import aurora.database.rsconsumer.CompositeMapCreator;
import aurora.database.service.SqlServiceContext;
import aurora.service.validation.Parameter;
import aurora.service.validation.ParameterListIterator;
import aurora.service.validation.ParameterParser;
import aurora.service.validation.ValidationException;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.event.Configuration;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IConfigurable;
import uncertain.ocm.OCManager;

public class RawSqlService
implements IConfigurable {
    public static final String UPDATE = "update";
    public static final String QUERY = "query";
    public static final FetchDescriptor DEFAULT_FETCH_DESCRIPTOR = new FetchDescriptor();
    Collection mParamList;
    StringBuffer mSql;
    String mType;
    Configuration mConfiguration;
    String mDatabaseType;
    boolean mTrace;
    ResultSetLoader mRsLoader = new ResultSetLoader();
    BusinessModel mModel;
    OCManager mOcManager;
    String dataSourceName;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    protected RawSqlService(OCManager ocManager) {
        this.mOcManager = ocManager;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public boolean isQuery() {
        return QUERY.equalsIgnoreCase(this.mType);
    }

    public boolean isUpdate() {
        return UPDATE.equalsIgnoreCase(this.mType);
    }

    public void addParameters(CompositeMap params) {
        Iterator it = params.getChildIterator();
        if (it == null) {
            return;
        }
        if (this.mParamList != null) {
            this.mParamList.clear();
        }
        this.mParamList = new LinkedList();
        while (it.hasNext()) {
            CompositeMap map = (CompositeMap)it.next();
            Parameter param = new Parameter();
            this.mOcManager.populateObject(map, param);
            this.mParamList.add(param);
        }
    }

    void setSqlString(String sql) {
        if (this.mSql == null) {
            this.mSql = new StringBuffer(sql);
        } else {
            this.mSql.setLength(0);
            this.mSql.append(sql);
        }
    }

    public void addSql(CompositeMap m) {
        this.setSqlString(m.getText());
    }

    public void addUpdate(CompositeMap m) {
        this.setSqlString(m.getText());
        this.mType = UPDATE;
    }

    public void addQuery(CompositeMap m) {
        this.setSqlString(m.getText());
        this.mType = QUERY;
    }

    public void parseParameter(SqlServiceContext context) throws ValidationException {
        CompositeMap parameter = context.getCurrentParameter();
        boolean parsed = parameter.getBoolean("__parameter_parsed__", false);
        if (!parsed) {
            ParameterParser parser = ParameterParser.getInstance();
            List desc = null;
            if (this.mParamList != null) {
                desc = parser.parse(parameter, new ParameterListIterator(this.mParamList.iterator()));
            }
            if (desc != null) {
                ValidationException exp = new ValidationException(parameter, desc);
                throw exp;
            }
            if (this.mModel.getQueryFieldsList() != null) {
                BusinessModel.QueryFieldIterator it = new BusinessModel.QueryFieldIterator(this.mModel);
                desc = parser.parse(parameter, it);
                if (desc != null) {
                    ValidationException exp = new ValidationException(parameter, desc);
                    throw exp;
                }
            }
            parameter.putBoolean("__parameter_parsed__", true);
        }
    }

    ParsedSql createStatement(String sql) {
        ParsedSql stmt = new ParsedSql();
        if (this.mParamList != null) {
            stmt.defineParameters(this.mParamList);
        }
        stmt.parse(sql);
        return stmt;
    }

    ParsedSql createStatement() {
        return this.createStatement(this.mSql.toString());
    }

    void printTraceInfo(String type, SqlRunner runner, long exec_time) {
        ILogger logger = LoggingContext.getLogger(runner.getSqlServiceContext().getObjectContext(), "aurora.database");
        DBUtil.printTraceInfo(type, logger, runner);
        logger.log(Level.CONFIG, "Execution time:{0}", new Object[]{new Long(exec_time)});
    }

    SqlRunner createRunner(StringBuffer sql, SqlServiceContext context) {
        ParsedSql stmt = this.createStatement(sql.toString());
        SqlRunner runner = new SqlRunner(context, stmt);
        runner.setConnectionName(this.dataSourceName);
        runner.setTrace(this.getTrace());
        return runner;
    }

    public SqlRunner createRunner(SqlServiceContext context) {
        return this.createRunner(this.mSql, context);
    }

    public CompositeMap queryAsMap(SqlServiceContext context, FetchDescriptor desc) throws Exception {
        CompositeMap result = new CompositeMap("result");
        CompositeMapCreator compositeCreator = new CompositeMapCreator(result);
        this.query(context, compositeCreator, desc);
        return result;
    }

    public void query(SqlServiceContext context, IResultSetConsumer consumer, FetchDescriptor desc) throws Exception {
        ILogger logger = LoggingContext.getLogger(context.getObjectContext(), "aurora.database");
        this.parseParameter(context);
        this.mConfiguration.fireEvent("PopulateQuerySql", context.getObjectContext(), new Object[]{this, this.mSql});
        SqlRunner runner = this.createRunner(this.mSql, context);
        context.setSqlString(this.mSql);
        ResultSet rs = null;
        long exec_time = 0L;
        try {
            long tick = System.currentTimeMillis();
            rs = runner.query(context.getCurrentParameter());
            logger.config("query execute time:" + (System.currentTimeMillis() - tick));
            if (rs != null) {
                if (this.mModel != null && this.mModel.getFields() != null) {
                    this.mRsLoader.loadByConfig(rs, desc, this.mModel, consumer);
                } else {
                    this.mRsLoader.loadByResultSet(rs, desc, consumer);
                }
            }
            exec_time = System.currentTimeMillis() - tick;
            this.mConfiguration.fireEvent("QueryFinish", context.getObjectContext(), null);
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(rs);
            this.printTraceInfo(QUERY, runner, exec_time);
            throw throwable;
        }
        DBUtil.closeResultSet(rs);
        this.printTraceInfo(QUERY, runner, exec_time);
    }

    public void update(SqlServiceContext context) throws Exception {
        this.parseParameter(context);
        this.mConfiguration.fireEvent("PopulateQuerySql", context.getObjectContext(), new Object[]{this, this.mSql});
        SqlRunner runner = this.createRunner(context);
        try {
            runner.update(context.getCurrentParameter());
        }
        finally {
            this.printTraceInfo(UPDATE, runner, runner.getLastExecutionTime());
        }
    }

    public boolean updateBatch(SqlServiceContext context, Collection params) throws Exception {
        this.parseParameter(context);
        this.mConfiguration.fireEvent("PopulateQuerySql", context.getObjectContext(), new Object[]{this, this.mSql});
        SqlRunner runner = this.createRunner(context);
        try {
            boolean bl = runner.updateList(params);
            return bl;
        }
        finally {
            this.printTraceInfo(UPDATE, runner, runner.getLastExecutionTime());
        }
    }

    public boolean getTrace() {
        return this.mTrace;
    }

    public void setTrace(boolean trace) {
        this.mTrace = trace;
    }

    public void beginConfigure(CompositeMap config) {
        this.mModel = (BusinessModel)DynamicObject.cast(config, BusinessModel.class);
        this.mModel.makeReady();
    }

    public void endConfigure() {
    }

    public BusinessModel asBusinessModel() {
        return this.mModel;
    }

    public ResultSetLoader getResultSetLoader() {
        return this.mRsLoader;
    }

    public void setResultSetLoader(ResultSetLoader rsLoader) {
        this.mRsLoader = rsLoader;
    }

    public String getDatabaseType() {
        return this.mDatabaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.mDatabaseType = databaseType;
    }
}

