/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.sql;

import aurora.database.sql.AbstractStatement;
import aurora.database.sql.BaseField;
import aurora.database.sql.IAliasSettable;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseTable
extends AbstractStatement
implements IAliasSettable {
    String tableName;
    String alias;
    Map fields;

    public BaseTable(String name) {
        super(name);
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected abstract BaseField createFieldInstance(String var1, String var2);

    public BaseField getField(String name) {
        if (this.fields == null) {
            return null;
        }
        return (BaseField)this.fields.get(name);
    }

    public BaseField createField(String name, String alias) {
        BaseField field = this.getField(name);
        if (field != null) {
            return field;
        }
        field = this.createFieldInstance(name, alias);
        if (this.fields == null) {
            this.fields = new HashMap();
        }
        this.fields.put(name, field);
        return field;
    }

    public BaseField createField(String name) {
        return this.createField(name, null);
    }

    public boolean removeField(String name) {
        if (this.fields == null) {
            return false;
        }
        String key = name;
        BaseField fld = (BaseField)this.fields.get(key);
        if (fld == null) {
            return false;
        }
        fld.setParent(null);
        this.fields.remove(key);
        return true;
    }
}

