/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.sql.builder;

import aurora.database.profile.ISqlBuilderRegistry;
import aurora.database.sql.CompositeStatement;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.builder.AbstractSqlBuilder;
import java.util.Iterator;

public class DefaultCompositeBuilder
extends AbstractSqlBuilder {
    String mStatementPrefix = null;
    String mStatementSeparator = null;
    String mStatementPostfix = null;
    boolean inited = false;

    private void checkInit() {
        if (this.inited) {
            return;
        }
        if (this.getDatabaseProfile() == null) {
            return;
        }
        this.mStatementPrefix = this.getKeywordWithNull("composite_statement_prefix");
        this.mStatementSeparator = this.getKeywordWithNull("composite_statement_separator");
        this.mStatementPostfix = this.getKeywordWithNull("composite_statement_postfix");
        this.inited = true;
    }

    public void setRegistry(ISqlBuilderRegistry registry) {
        super.setRegistry(registry);
    }

    public String createSql(ISqlStatement sqlStatement) {
        this.checkInit();
        if (sqlStatement instanceof CompositeStatement) {
            Iterator it = ((CompositeStatement)sqlStatement).getStatements().iterator();
            StringBuffer sql = new StringBuffer();
            while (it.hasNext()) {
                ISqlStatement stmt = (ISqlStatement)it.next();
                String s = this.mRegistry.getSql(stmt);
                if (s == null) continue;
                sql.append(s);
                if (this.mStatementSeparator == null || s.endsWith(this.mStatementSeparator)) continue;
                sql.append(this.mStatementSeparator);
            }
            if (sql.length() > 0) {
                if (this.mStatementPrefix != null) {
                    sql.insert(0, this.mStatementPrefix);
                }
                if (this.mStatementPostfix != null) {
                    sql.append(this.mStatementPostfix);
                }
            }
            return sql.toString();
        }
        return null;
    }
}

