/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.sql.builder;

import aurora.database.profile.DatabaseProfile;
import aurora.database.sql.ConditionList;
import aurora.database.sql.IAliasSettable;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.Join;
import aurora.database.sql.OrderByField;
import aurora.database.sql.SelectField;
import aurora.database.sql.SelectSource;
import aurora.database.sql.SelectStatement;
import aurora.database.sql.StringConcatenater;
import aurora.database.sql.builder.AbstractSqlBuilder;
import java.util.Iterator;
import java.util.List;

public class DefaultSelectBuilder
extends AbstractSqlBuilder {
    public static final String EMPTY_WHERE = "";

    public boolean isUseJoinKeyword() {
        return DatabaseProfile.isUseJoinKeyword(this.getDatabaseProfile());
    }

    public String createSql(ISqlStatement sqlStatement) {
        if (sqlStatement instanceof SelectStatement) {
            return this.createSql((SelectStatement)sqlStatement);
        }
        if (sqlStatement instanceof SelectSource) {
            return this.createSql((SelectSource)sqlStatement);
        }
        if (sqlStatement instanceof SelectField) {
            return this.createSql((SelectField)sqlStatement);
        }
        if (sqlStatement instanceof OrderByField) {
            return ((OrderByField)sqlStatement).toSql(this.mRegistry);
        }
        return null;
    }

    public String createSql(SelectField field) {
        return field.getNameForOperate();
    }

    public String getFromPart(SelectStatement stmt) {
        boolean useJoinKeyword = this.isUseJoinKeyword();
        StringBuffer result = new StringBuffer();
        result.append(this.getKeyword("FROM")).append(" ");
        boolean is_use_join = false;
        List lst = stmt.getJoins();
        if (lst != null && lst.size() > 0) {
            is_use_join = true;
        }
        if (is_use_join &= useJoinKeyword) {
            int id = 0;
            for (Join join : lst) {
                join.setOrder(id++);
                result.append(this.mRegistry.getSql(join));
            }
        } else {
            StringConcatenater list = new StringConcatenater();
            for (SelectSource source : stmt.getFromListForRead()) {
                list.append(this.mRegistry.getSql(source));
            }
            result.append(list.getContent());
        }
        return result.toString();
    }

    public String getWherePart(SelectStatement stmt) {
        StringBuffer buf = new StringBuffer();
        ConditionList where = stmt.getWhereClause();
        if (this.isUseJoinKeyword()) {
            if (where.size() == 0) {
                return EMPTY_WHERE;
            }
            buf.append(this.getKeyword("WHERE")).append(" ");
            buf.append(this.mRegistry.getSql(where));
            return buf.toString();
        }
        ConditionList join_conditions = stmt.getJoinConditions();
        if (join_conditions.size() == 0 && where.size() == 0) {
            return EMPTY_WHERE;
        }
        ConditionList all = new ConditionList();
        if (where.size() > 0) {
            all.addCondition(where);
        }
        if (join_conditions.size() > 0) {
            all.addCondition(join_conditions);
        }
        buf.append(this.getKeyword("WHERE")).append(" ");
        buf.append(this.mRegistry.getSql(all));
        return buf.toString();
    }

    public String getSelectFields(SelectStatement stmt) {
        StringBuffer result = new StringBuffer();
        result.append(this.getKeyword("SELECT")).append(" ");
        Iterator it = stmt.getFieldsForRead().iterator();
        StringConcatenater flds = new StringConcatenater();
        while (it.hasNext()) {
            String alias;
            ISqlStatement field = (ISqlStatement)it.next();
            String field_name = this.mRegistry.getSql(field);
            if (field instanceof IAliasSettable && (alias = ((IAliasSettable)((Object)field)).getAlias()) != null) {
                field_name = String.valueOf(field_name) + " " + this.getKeyword("AS") + " " + alias;
            }
            flds.append(field_name);
        }
        result.append(flds.getContent());
        return result.toString();
    }

    public String createSql(SelectSource source) {
        StringBuffer result = new StringBuffer();
        if (source.isSubQuery()) {
            result.append("( ");
            result.append(this.createSql(source.getSubQuery()));
            result.append(") ");
        } else {
            result.append(source.getTableName());
        }
        if (source.getAlias() != null) {
            result.append(" ");
            result.append(source.getAlias());
        }
        return result.toString();
    }

    public String createOrderByPart(SelectStatement statement) {
        StringConcatenater list = new StringConcatenater();
        List order_by = statement.getOrderByFields();
        if (order_by != null) {
            for (OrderByField field : order_by) {
                list.append(field.toSql(this.mRegistry));
            }
            String content = list.getContent();
            if (content.length() == 0) {
                return null;
            }
            return String.valueOf(this.getKeyword("ORDER BY")) + " " + content;
        }
        return null;
    }

    public String createSql(SelectStatement stmt) {
        StringBuffer result = new StringBuffer();
        stmt.createDefaultAlias("t");
        result.append(this.getSelectFields(stmt)).append("\r\n");
        result.append(this.getFromPart(stmt)).append("\r\n");
        result.append(this.getWherePart(stmt));
        String order_by = this.createOrderByPart(stmt);
        if (order_by != null) {
            result.append("\r\n").append(order_by);
        }
        return result.toString();
    }
}

