/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class Accordion
extends Component {
    private static final String DEFAULT_CLASS = "layout-accordion";
    private static final String ACCORDIONS = "accordions";
    private static final String SINGLE_MODE = "singlemode";
    private static final String PROPERTITY_REF = "ref";
    private static final String PROPERTITY_SELECTED = "selected";
    private int bodyHeight;
    private int stripHeight = 25;

    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "accordion/Accordion.css");
        this.addJavaScript(session, context, "accordion/Accordion.js");
    }

    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        this.addConfig("stripheight", new Integer(this.stripHeight));
        map.put(ACCORDIONS, this.createAccordions(session, context));
        map.put("config", this.getConfigString());
    }

    private String createAccordions(BuildSession session, ViewContext context) throws IOException {
        List childs;
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap accordions = view.getChild(ACCORDIONS);
        StringBuffer sb = new StringBuffer();
        JSONArray jsons = new JSONArray();
        if (accordions != null && (childs = accordions.getChilds()) != null) {
            int numAccordions = childs.size();
            int i = 0;
            boolean isSelected = false;
            boolean singleMode = view.getBoolean(SINGLE_MODE, true);
            this.bodyHeight = ((Integer)map.get("height") - numAccordions * this.stripHeight) / (singleMode ? 1 : numAccordions);
            Iterator it = childs.iterator();
            this.addConfig(SINGLE_MODE, new Boolean(singleMode));
            while (it.hasNext()) {
                CompositeMap accordion = (CompositeMap)it.next();
                if (!(isSelected && singleMode || !"true".equals(accordion.getString(PROPERTITY_SELECTED, "")))) {
                    isSelected = true;
                    sb.append(this.createAccordion(session, context, accordion, true));
                } else {
                    sb.append(this.createAccordion(session, context, accordion, false));
                }
                jsons.put(new JSONObject(accordion));
                ++i;
            }
        }
        this.addConfig("items", jsons);
        return sb.toString();
    }

    private String createAccordion(BuildSession session, ViewContext context, CompositeMap accordion, boolean isSelected) throws IOException {
        CompositeMap model = context.getModel();
        int accordionHeight = isSelected ? this.bodyHeight + this.stripHeight : this.stripHeight;
        String stripClass = isSelected ? "item-accordion selected" : "item-accordion";
        StringBuffer sb = new StringBuffer();
        sb.append("<DIV class='" + stripClass + "' style='height:" + accordionHeight + "px'><DIV class='strip' style='height:" + this.stripHeight + "px;line-height:" + this.stripHeight + "px'>");
        sb.append(session.getLocalizedPrompt(accordion.getString("prompt")));
        sb.append("</DIV><DIV class='item-accordion-body' style='height:" + this.bodyHeight + "px;'>");
        String ref = accordion.getString(PROPERTITY_REF, "");
        if ("".equals(ref)) {
            List accordionChilds = accordion.getChilds();
            if (accordionChilds != null) {
                for (CompositeMap accordionChild : accordionChilds) {
                    try {
                        sb.append(session.buildViewAsString(model, accordionChild));
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage());
                    }
                }
            } else if (!"".equals(accordion.getText())) {
                sb.append(accordion.getText());
            }
        }
        accordion.putString(PROPERTITY_REF, TextParser.parse(ref, model));
        sb.append("</DIV></DIV>");
        return sb.toString();
    }
}

