/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;

public class Field
extends Component {
    protected static final String CLASSNAME_WRAP = "item-wrap";
    protected static final String PROPERTITY_REQUIRED = "required";
    protected static final String PROPERTITY_READONLY = "readonly";
    protected static final String PROPERTITY_MAX_LENGHT = "maxlength";
    protected static final String PROPERTITY_RENDERER = "renderer";
    protected static final String CLASSNAME_NOTBLANK = "item-notBlank";
    protected static final String CLASSNAME_READONLY = "item-readOnly";

    protected String getDefaultClass(BuildSession session, ViewContext context) {
        boolean readOnly;
        CompositeMap view = context.getView();
        boolean notBlank = view.getBoolean(PROPERTITY_REQUIRED, false);
        String wrapClass = CLASSNAME_WRAP;
        if (notBlank) {
            wrapClass = String.valueOf(wrapClass) + " item-notBlank";
        }
        if (readOnly = view.getBoolean(PROPERTITY_READONLY, false)) {
            wrapClass = String.valueOf(wrapClass) + " item-readOnly";
        }
        return wrapClass;
    }

    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        boolean readOnly;
        String maxlength;
        String renderer;
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();
        Map map = context.getMap();
        boolean notBlank = view.getBoolean(PROPERTITY_REQUIRED, false);
        map.put(PROPERTITY_REQUIRED, notBlank);
        if (notBlank) {
            this.addConfig(PROPERTITY_REQUIRED, notBlank);
        }
        this.addConfig(PROPERTITY_REQUIRED, notBlank);
        boolean hidden = view.getBoolean("hidden", false);
        if (hidden) {
            this.addConfig("hidden", hidden);
        }
        if ((renderer = view.getString(PROPERTITY_RENDERER)) != null) {
            this.addConfig(PROPERTITY_RENDERER, renderer);
        }
        if ((maxlength = view.getString(PROPERTITY_MAX_LENGHT)) != null) {
            this.addConfig(PROPERTITY_MAX_LENGHT, maxlength);
        }
        if (readOnly = view.getBoolean(PROPERTITY_READONLY, false)) {
            map.put(PROPERTITY_READONLY, PROPERTITY_READONLY);
        }
        this.addConfig(PROPERTITY_READONLY, readOnly);
    }
}

