/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.service.ServiceThreadLocal;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class HTMLInclude
implements IViewBuilder {
    private IDatabaseServiceFactory factory;
    private static final String PROPERTITY_PATH_FIELD = "pathfield";
    private static final String PROPERTITY_MODEL = "model";
    private static final String PROPERTITY_PARAMS = "params";
    private String articlePath;
    private String sourcePath;
    private String titlePattern = "<title>.*</title>";
    private String metaPattern = "<meta[^>]*>";
    private String headPattern = "<head>(.*)</head>";
    private String htmlPattern = ".*<html[^>]*>(.*)</html>.*";
    private String bodyPattern = "(.*)<body[^>]*>(.*)</body>(.*)";
    private String scriptPattern = "<script[^>]*src=([\"'])([^'\"]*)\\1[^>]*(/|.*/script)>";
    private String linkPattern = "<link[^>]*href=([\"'])([^'\"]*)\\1[^>]*/?>";
    private ClassLoader mClassLoader = Thread.currentThread().getContextClassLoader();

    public HTMLInclude(IDatabaseServiceFactory factory) {
        this.factory = factory;
    }

    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        Writer out = session.getWriter();
        try {
            this.init(session, view_context);
            String source = this.getArticalSource(this.articlePath);
            if (source != null && !"".equals(source)) {
                out.write(source);
            }
        }
        catch (ClassNotFoundException e) {
            out.write(e.getMessage());
        }
        catch (Exception e) {
            throw new ViewCreationException(e);
        }
    }

    private void init(BuildSession session, ViewContext view_context) throws Exception {
        BusinessModelService service;
        CompositeMap resultMap;
        CompositeMap context = ServiceThreadLocal.getCurrentThreadContext();
        if (context == null) {
            throw new IllegalStateException("No service context set in ThreadLocal yet");
        }
        CompositeMap view = view_context.getView();
        String pathField = view.getString(PROPERTITY_PATH_FIELD);
        String model = view.getString(PROPERTITY_MODEL);
        CompositeMap params = view.getChild(PROPERTITY_PARAMS);
        HashMap map = new HashMap();
        if (params != null) {
            Iterator pit = params.getChildIterator();
            while (pit.hasNext()) {
                CompositeMap param = (CompositeMap)pit.next();
                map.put(param.get("name"), TextParser.parse((String)param.get("value"), view_context.getModel()));
            }
        }
        if ((resultMap = (service = this.factory.getModelService(model, context)).queryAsMap(map)) == null || resultMap.getChilds() == null) {
            throw new ClassNotFoundException("\u6587\u7ae0\u672a\u627e\u5230\uff0c\u8f93\u5165\u7684\u8def\u5f84\u4e0d\u6b63\u786e\u3002");
        }
        Iterator it = resultMap.getChildIterator();
        while (it.hasNext()) {
            String path = ((CompositeMap)it.next()).getString(pathField);
            if (path == null) continue;
            this.articlePath = "../.." + path;
            this.sourcePath = String.valueOf(session.getContextPath()) + path.replaceAll("\\\\", "/").replaceAll("(.*/)[^/]*$", "$1");
            break;
        }
    }

    private String getSource(String path) throws IOException {
        InputStream stream = null;
        try {
            int begin;
            URL url = this.mClassLoader.getResource(path);
            String file = url == null ? null : url.getFile();
            boolean need_stream = false;
            if (file == null) {
                need_stream = true;
            } else {
                File f = new File(file);
                if (!f.exists()) {
                    need_stream = true;
                }
            }
            stream = need_stream ? this.mClassLoader.getResourceAsStream(path) : new FileInputStream(file);
            if (stream == null) {
                throw new IOException("Can't get resource from " + path);
            }
            StringBuffer sb = new StringBuffer();
            byte[] buffer = new byte[1024];
            while ((begin = stream.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, begin));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private String getArticalSource(String path) throws IOException {
        return this.pase(this.getSource(path));
    }

    private String pase(String source) {
        if (source == null || "".equals(source)) {
            return "";
        }
        return this.replaceAll(this.linkPattern, this.replaceAll(this.scriptPattern, this.replaceAll(this.metaPattern, this.replaceAll(this.titlePattern, this.replaceAll(this.bodyPattern, this.replaceAll(this.headPattern, this.replaceAll(this.htmlPattern, this.replaceAll("</link>", source, ""), "$1"), "$1"), "$1$2$3"), ""), ""), "<script src='" + this.sourcePath + "$2'></script>"), "<link rel='stylesheet' type='text/css' href='" + this.sourcePath + "$2'/>");
    }

    private String replaceAll(String regex, CharSequence input, String replacement) {
        return Pattern.compile(regex, 32).matcher(input).replaceAll(replacement);
    }

    public String[] getBuildSteps(ViewContext context) {
        return null;
    }
}

