/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.exception;

import aurora.application.util.LanguageUtil;
import aurora.i18n.ILocalizedMessageProvider;
import aurora.service.ServiceContext;
import aurora.service.exception.DefaultExceptionDescriptor;
import aurora.service.exception.ExceptionDescriptor;
import aurora.service.exception.IExceptionDescriptor;
import java.util.HashMap;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.core.ConfigurationError;
import uncertain.core.UncertainEngine;
import uncertain.ocm.IObjectRegistry;

public class ExceptionDescriptorConfig
implements IExceptionDescriptor {
    Map mClassMap = new HashMap();
    IExceptionDescriptor mDefaultDescriptor;
    UncertainEngine mUncertainEngine;

    public ExceptionDescriptorConfig(UncertainEngine engine) {
        this.mUncertainEngine = engine;
        this.mDefaultDescriptor = new DefaultExceptionDescriptor();
        this.registerInstance();
    }

    private void prepareMessageProvider(ServiceContext context) {
        ILocalizedMessageProvider mp = (ILocalizedMessageProvider)context.getInstanceOfType(ILocalizedMessageProvider.class);
        if (mp == null && (mp = LanguageUtil.getLocalizedMessageProvider(this.mUncertainEngine.getObjectRegistry(), context.getObjectContext())) != null) {
            context.setInstanceOfType(ILocalizedMessageProvider.class, mp);
        }
    }

    public CompositeMap process(ServiceContext context, Throwable exception) {
        this.prepareMessageProvider(context);
        IExceptionDescriptor desc = (IExceptionDescriptor)this.mClassMap.get(exception.getClass().getName());
        if (desc != null) {
            return desc.process(context, exception);
        }
        if (this.mDefaultDescriptor != null) {
            return this.mDefaultDescriptor.process(context, exception);
        }
        return null;
    }

    public void addExceptionDescriptor(CompositeMap item) throws Exception {
        ExceptionDescriptor desc = (ExceptionDescriptor)DynamicObject.cast(item, ExceptionDescriptor.class);
        String exp = desc.getException();
        String cls = desc.getHandleClass();
        if (cls == null) {
            throw new ConfigurationError("Must set 'handleClass' property");
        }
        Class<?> handle_cls = Class.forName(cls);
        Object instance = this.mUncertainEngine.getObjectRegistry().getInstanceOfType(handle_cls);
        if (instance == null) {
            instance = this.mUncertainEngine.getObjectCreator().createInstance(handle_cls);
        }
        if (instance == null) {
            throw new IllegalArgumentException("Can't create exception handle class " + handle_cls.getName());
        }
        this.mUncertainEngine.getOcManager().populateObject(item, instance);
        if (exp != null) {
            this.mClassMap.put(exp, instance);
        }
    }

    public IExceptionDescriptor getDefaultDescriptor() {
        return this.mDefaultDescriptor;
    }

    public void setDefaultDescriptor(IExceptionDescriptor defaultDescriptor) {
        this.mDefaultDescriptor = defaultDescriptor;
    }

    public void registerInstance() {
        IObjectRegistry os = this.mUncertainEngine.getObjectRegistry();
        Object o = os.getInstanceOfType(IExceptionDescriptor.class);
        if (o == null) {
            os.registerInstance(IExceptionDescriptor.class, this);
        }
    }
}

