/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.json;

import aurora.service.ServiceContext;
import aurora.service.json.JSONServiceContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.JSONAdaptor;

public class JSONDispatcher {
    public static final String DEFAULT_JSON_CONTENT_TYPE = "application/json;charset=utf-8";
    public static final String HEAD_JSON_PARAMETER = "json-parameter";
    public static final String DEFAULT_JSON_PARAMETER = "_request_data";
    public static final String KEY_WRITE_BACK_INPUT = "write_back_input";
    static final JSONObject EMPTY_JSON_OBJECT = new JSONObject();
    ServiceContext service_context;
    HttpServletRequest request;
    HttpServletResponse response;
    String output;
    String array;
    Set arrayNameSet;

    public int preParseParameter(JSONServiceContext ct) throws Exception {
        String content;
        this.service_context = ct;
        this.request = ct.getRequest();
        this.response = ct.getResponse();
        this.request.setCharacterEncoding("utf-8");
        String jparam = this.request.getHeader(HEAD_JSON_PARAMETER);
        if (jparam == null) {
            jparam = DEFAULT_JSON_PARAMETER;
        }
        if ((content = this.request.getParameter(jparam)) != null) {
            JSONObject jobj = new JSONObject(content);
            CompositeMap root = JSONAdaptor.toMap(jobj);
            if (root == null) {
                return 2;
            }
            CompositeMap param = root.getChild("parameter");
            if (param != null) {
                this.service_context.setParameter(param);
            }
            return 2;
        }
        return 0;
    }

    void prepareResponse(HttpServletResponse response) {
        response.setContentType(DEFAULT_JSON_CONTENT_TYPE);
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
    }

    void prepareArrayNameSet() {
        if (this.arrayNameSet == null) {
            this.arrayNameSet = new HashSet();
        }
        this.arrayNameSet.clear();
        Iterator it = this.service_context.getModel().getChildIterator();
        if (it != null) {
            while (it.hasNext()) {
                CompositeMap item = (CompositeMap)it.next();
                this.arrayNameSet.add(item.getName());
            }
        }
    }

    public void writeResponse() throws IOException, JSONException {
        JSONObject json = new JSONObject();
        json.put("success", this.service_context.isSuccess());
        boolean write_result = this.service_context.getBoolean("write_result", true);
        if (write_result) {
            CompositeMap result = null;
            this.prepareArrayNameSet();
            if (this.output != null) {
                Object obj = this.service_context.getObjectContext().getObject(this.output);
                if (!(obj instanceof CompositeMap)) {
                    throw new IllegalArgumentException("Target for JSON output is not instance of CompositeMap: " + obj);
                }
                result = (CompositeMap)obj;
            } else {
                result = this.service_context.getModel();
            }
            if (result != null) {
                JSONObject o = JSONAdaptor.toJSONObject(result, this.arrayNameSet);
                json.put("result", o);
            }
        }
        this.prepareResponse(this.response);
        PrintWriter out = this.response.getWriter();
        json.write(out);
    }

    public void onCreateSuccessResponse() throws IOException, JSONException {
        this.writeResponse();
    }

    public void onCreateFailResponse(ServiceContext context) throws IOException, JSONException {
        this.prepareResponse(this.response);
        PrintWriter out = this.response.getWriter();
        out.println("{ \"success\":false ");
        CompositeMap error = context.getError();
        if (error != null) {
            out.println(",error:");
            out.println(JSONAdaptor.toJSONObject(error).toString());
        }
        out.println("} ");
        out.flush();
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getArray() {
        return this.array;
    }

    public void setArray(String array) {
        this.array = array;
        if (this.arrayNameSet != null) {
            this.arrayNameSet.clear();
        }
        this.arrayNameSet = new HashSet();
        if (array != null) {
            String[] s = array.split(",");
            int i = 0;
            while (i < s.length) {
                this.arrayNameSet.add(s[i].trim());
                ++i;
            }
        }
    }
}

