/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.validation;

import aurora.service.validation.IParameter;
import aurora.service.validation.IParameterIterator;
import java.util.Collection;
import java.util.Iterator;

public class CompositeParameterIterator
implements IParameterIterator {
    Collection mParameterList;
    Iterator mListIterator;
    IParameterIterator mCurrentIterator;

    public CompositeParameterIterator(Collection parameterList) {
        if (parameterList == null) {
            throw new NullPointerException("Collection is null");
        }
        this.mParameterList = parameterList;
        this.mListIterator = parameterList.iterator();
        this.moveNext();
    }

    private void moveNext() {
        this.mCurrentIterator = this.mListIterator.hasNext() ? (IParameterIterator)this.mListIterator.next() : null;
    }

    public void goFirst() {
        this.mListIterator = this.mParameterList.iterator();
        this.moveNext();
    }

    public boolean hasNext() {
        if (this.mCurrentIterator == null) {
            return false;
        }
        if (!this.mCurrentIterator.hasNext()) {
            this.moveNext();
            return this.hasNext();
        }
        return this.mCurrentIterator.hasNext();
    }

    public IParameter next() {
        if (this.mCurrentIterator != null) {
            IParameter param = this.mCurrentIterator.next();
            if (!this.mCurrentIterator.hasNext()) {
                this.moveNext();
            }
            return param;
        }
        return null;
    }
}

