/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite;

import java.io.IOException;
import java.io.Reader;
import uncertain.composite.CompositeMap;
import uncertain.util.QuickTagParser;
import uncertain.util.TagParseHandle;

public class TextParser {
    public static String parse(String text, CompositeMap map) {
        QuickTagParser parser = null;
        try {
            parser = new QuickTagParser();
            String string = parser.parse(text, (TagParseHandle)new ParseHandle(map));
            return string;
        }
        finally {
            if (parser != null) {
                parser.clear();
            }
        }
    }

    public static String parse(Reader reader, CompositeMap map) throws IOException {
        QuickTagParser parser = null;
        try {
            parser = new QuickTagParser();
            String string = parser.parse(reader, (TagParseHandle)new ParseHandle(map));
            return string;
        }
        finally {
            if (parser != null) {
                parser.clear();
            }
        }
    }

    public static class ParseHandle
    implements TagParseHandle {
        CompositeMap map;

        public ParseHandle(CompositeMap mp) {
            this.map = mp;
        }

        public String ProcessTag(int index, String tag) {
            Object obj = this.map.getObject(tag);
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }

        public int ProcessCharacter(int index, char ch) {
            return ch;
        }
    }
}

