/*
 * Decompiled with CFR 0.152.
 */
package uncertain.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class BasicStreamHandler
extends Handler {
    OutputStream mStream;
    PrintStream mWriter;

    public BasicStreamHandler(OutputStream stream) {
        this.mStream = stream;
        this.mWriter = new PrintStream(this.mStream);
    }

    public void close() throws SecurityException {
        if (this.mStream != null) {
            try {
                this.mStream.close();
            }
            catch (IOException ex) {
                this.handleException(ex);
            }
        }
    }

    public void flush() {
        try {
            this.mStream.flush();
        }
        catch (IOException ex) {
            this.handleException(ex);
        }
    }

    public synchronized void publish(LogRecord record) {
        if (!super.isLoggable(record)) {
            return;
        }
        Formatter f = this.getFormatter();
        String content = f.format(record);
        try {
            this.mWriter.write(content.getBytes());
            this.flush();
        }
        catch (IOException ex) {
            this.handleException(ex);
        }
    }

    void handleException(Exception thrown) {
        thrown.printStackTrace();
        ErrorManager em = this.getErrorManager();
        if (em != null) {
            em.error("Error when writting log file", thrown, -1);
        } else {
            thrown.printStackTrace();
        }
    }
}

