/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import uncertain.cache.CacheFactoryConfig;
import uncertain.cache.ICache;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.event.Configuration;
import uncertain.ocm.OCManager;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;

public class ProcedureManager
implements IProcedureManager {
    public static final String CACHE_NAME = "ProcedureConfig";
    static final ProcedureManager DEFAULT_INSTANCE = new ProcedureManager();
    public static final String DEFAULT_PROC_EXTENSION = "proc";
    UncertainEngine mUncertainEngine;
    OCManager mOCManager;
    CompositeLoader mCompositeLoader;
    boolean mIsCache = false;
    ICache mCache;

    public static ProcedureManager getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public ProcedureManager() {
        this.mOCManager = OCManager.getInstance();
        this.mCompositeLoader = CompositeLoader.createInstanceForOCM(DEFAULT_PROC_EXTENSION);
    }

    public ProcedureManager(UncertainEngine uncertainEngine) {
        this.mUncertainEngine = uncertainEngine;
        this.mOCManager = this.mUncertainEngine.getOcManager();
        this.mCompositeLoader = CompositeLoader.createInstanceForOCM(DEFAULT_PROC_EXTENSION);
    }

    public boolean getIsCache() {
        return this.mIsCache;
    }

    public void setIsCache(boolean isCache) {
        this.mIsCache = isCache;
    }

    public ICache getCache() {
        return this.mCache;
    }

    public void setCache(ICache cache) {
        this.mCache = cache;
    }

    public Procedure createProcedure() {
        Procedure proc = new Procedure();
        return proc;
    }

    public Procedure createProcedure(CompositeMap proc_config) {
        Procedure proc = (Procedure)this.mOCManager.createObject(proc_config);
        return proc;
    }

    public ProcedureRunner createProcedureRunner() {
        ProcedureRunner runner = new ProcedureRunner();
        return runner;
    }

    private Procedure loadProcedureNC(String name) {
        CompositeMap map = this.mCompositeLoader.silently().loadFromClassPath(name);
        return this.createProcedure(map);
    }

    public Procedure loadProcedure(String name) {
        if (!this.mIsCache || this.mCache == null) {
            return this.loadProcedureNC(name);
        }
        Procedure proc = (Procedure)this.mCache.getValue(name);
        if (proc == null) {
            proc = this.loadProcedureNC(name);
            this.mCache.setValue(name, proc);
        }
        return proc;
    }

    public Configuration createConfig() {
        return this.mUncertainEngine == null ? new Configuration() : this.mUncertainEngine.createConfig();
    }

    public CompositeLoader getCompositeLoader() {
        return this.mCompositeLoader;
    }

    public OCManager getOCManager() {
        return this.mOCManager;
    }

    public void onInitialize() {
        this.mCache = CacheFactoryConfig.getNamedCache(this.mUncertainEngine.getObjectRegistry(), CACHE_NAME);
        if (this.mCache != null) {
            this.setCache(this.mCache);
            this.setIsCache(true);
        } else {
            this.setIsCache(false);
        }
    }

    public void initContext(CompositeMap context) {
        if (this.mUncertainEngine != null) {
            this.mUncertainEngine.initContext(context);
        }
    }

    public void destroyContext(CompositeMap context_map) {
        if (this.mUncertainEngine != null) {
            this.mUncertainEngine.destroyContext(context_map);
        }
    }
}

