/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.event.Configuration;
import uncertain.event.RuntimeContext;
import uncertain.logging.DummyLogger;
import uncertain.logging.ILogger;
import uncertain.logging.ILoggerProvider;
import uncertain.ocm.OCManager;
import uncertain.proc.EntryList;
import uncertain.proc.Field;
import uncertain.proc.IEntry;
import uncertain.proc.IExceptionHandle;
import uncertain.proc.Procedure;
import uncertain.proc.trace.StackTraceManager;

public class ProcedureRunner {
    public static final String LOGGING_TOPIC = "uncertain.proc";
    CompositeMap mContext;
    Procedure mProcedure;
    ProcedureRunner mCaller;
    RuntimeContext mRuntimeContext;
    UncertainEngine mUncertainEngine;
    boolean mIsContinue = true;
    boolean mRunningList = false;
    boolean mInExceptionHandle = false;
    boolean mResumeAfterException = false;
    boolean mSaveStackTrace = true;
    ListIterator current_iterator;
    EntryList current_entry_list;
    int current_event_sequence = 0;
    String current_event = null;
    Throwable lastException;
    Throwable procException;
    ILogger mLogger;
    StackTraceManager mStackTraceManager;

    public ProcedureRunner() {
        this.setContext(new CompositeMap("runtime-context"));
    }

    public ProcedureRunner(Procedure proc) {
        this();
        this.setProcedure(proc);
    }

    public CompositeMap getContext() {
        return this.mContext;
    }

    public void setContext(CompositeMap context) {
        this.mContext = context;
        this.mRuntimeContext = RuntimeContext.getInstance(context);
        this.mStackTraceManager = this.mRuntimeContext.getStackTraceManager();
        this.createDefaultConfig();
    }

    public Procedure getProcedure() {
        return this.mProcedure;
    }

    public void setProcedure(Procedure procedure) {
        this.mProcedure = procedure;
        this.reset();
    }

    public ProcedureRunner getCaller() {
        return this.mCaller;
    }

    public void reset() {
        if (this.mProcedure == null) {
            throw new IllegalArgumentException("Procedure not set");
        }
        this.current_entry_list = this.mProcedure;
        this.current_iterator = null;
        this.mIsContinue = true;
    }

    public void stop() {
        this.mIsContinue = false;
    }

    public boolean isRunning() {
        return this.mIsContinue;
    }

    public void setResumeAfterException(boolean flag) {
        this.mResumeAfterException = flag;
    }

    public boolean locateTo(String entry_name) {
        IEntry entry = null;
        if (this.current_entry_list != null) {
            entry = this.current_entry_list.getNamedEntry(entry_name);
        }
        if (entry == null) {
            entry = this.mProcedure.getNamedEntry(entry_name);
        }
        if (entry == null) {
            throw new IllegalStateException("Can't find entry '" + entry_name + "' in current procedure");
        }
        IEntry owner = entry.getOwner();
        if (owner == null || !(owner instanceof EntryList)) {
            throw new IllegalStateException("Node entry '" + entry_name + "' has no parent");
        }
        this.current_entry_list = (EntryList)owner;
        this.current_iterator = this.current_entry_list.locateEntry(entry);
        if (this.current_iterator == null) {
            throw new IllegalStateException("Internal structure error, named entry map is corrupt");
        }
        return true;
    }

    public void throwException(Throwable thr) {
        this.procException = thr.getCause();
        if (this.procException == null) {
            this.procException = thr;
        }
        this.lastException = this.procException;
        this.mResumeAfterException = false;
        this.mRuntimeContext.setException(this.procException);
        this.mRuntimeContext.setSuccess(false);
        if (this.handleException(this.procException)) {
            this.mRuntimeContext.setException(null);
            this.mRuntimeContext.setLastHandledException(this.procException);
            this.procException = null;
        }
        if (!this.mResumeAfterException) {
            this.stop();
        }
    }

    public void throwUnhandledException(Throwable thr) {
        this.mRuntimeContext.setSuccess(false);
        this.procException = thr.getCause();
        if (this.procException == null) {
            this.procException = thr;
        }
        this.lastException = this.procException;
        this.stop();
    }

    public Throwable getException() {
        return this.procException;
    }

    public void checkAndThrow() throws Exception {
        Throwable thr = this.getException();
        if (thr == null) {
            return;
        }
        if (this.mStackTraceManager != null) {
            this.mStackTraceManager.fillException(thr);
        }
        if (thr instanceof Exception) {
            throw (Exception)thr;
        }
        if (thr instanceof Error) {
            throw (Error)thr;
        }
    }

    public void addExceptionHandle(IExceptionHandle handle) {
        Configuration config = this.getConfiguration();
        if (config != null) {
            config.addExceptionHandle(handle);
        }
    }

    public void addExceptionHandles(Collection handle_list) {
        Configuration config = this.getConfiguration();
        if (config != null) {
            config.addExceptionHandles(handle_list);
        }
    }

    public boolean handleException(Throwable thr) {
        List exception_handle_list;
        Configuration config = this.getConfiguration();
        if (this.mInExceptionHandle) {
            this.throwUnhandledException(thr);
            return false;
        }
        List list = exception_handle_list = config == null ? null : config.getExceptionHandles();
        if (exception_handle_list == null) {
            return false;
        }
        this.mInExceptionHandle = true;
        for (IExceptionHandle handle : exception_handle_list) {
            boolean result = handle.handleException(this, thr);
            if (!result) continue;
            this.mInExceptionHandle = false;
            return true;
        }
        this.mInExceptionHandle = false;
        return false;
    }

    public void clearException() {
        this.procException = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            if (this.current_entry_list != null && this.current_iterator == null) {
                if (this.mSaveStackTrace && this.mStackTraceManager != null) {
                    this.mStackTraceManager.enter(this.current_entry_list);
                }
                this.current_entry_list.run(this);
                if (!this.mSaveStackTrace) return;
                if (this.mStackTraceManager == null) return;
                this.mStackTraceManager.exit();
                return;
            }
            while (this.mIsContinue) {
                if (this.current_entry_list == null) return;
                if (this.current_iterator == null) {
                    return;
                }
                while (true) {
                    if (!this.mIsContinue || !this.current_iterator.hasNext()) {
                        if (!this.mRunningList) break;
                        return;
                    }
                    IEntry entry = (IEntry)this.current_iterator.next();
                    if (this.mSaveStackTrace && this.mStackTraceManager != null) {
                        this.mStackTraceManager.enter(entry);
                    }
                    entry.run(this);
                    if (!this.mSaveStackTrace || this.mStackTraceManager == null) continue;
                    this.mStackTraceManager.exit();
                }
                EntryList prev = this.current_entry_list;
                IEntry owner = this.current_entry_list.getOwner();
                if (owner == null) {
                    this.current_entry_list = null;
                    continue;
                }
                if (owner instanceof EntryList) {
                    this.current_entry_list = (EntryList)owner;
                    this.current_iterator = this.current_entry_list.locateEntry(prev);
                    if (this.current_iterator == null) continue;
                    this.current_iterator.next();
                    continue;
                }
                this.current_entry_list = null;
            }
            return;
        }
        catch (Throwable ex) {
            this.throwException(ex);
        }
    }

    public void run(EntryList list) {
        List l = list.getEntryList();
        if (l == null) {
            return;
        }
        if (l.size() == 0) {
            return;
        }
        EntryList prev_entry_list = this.current_entry_list;
        ListIterator prev_iterator = this.current_iterator;
        boolean prev_flag = this.mRunningList;
        this.current_entry_list = list;
        this.current_iterator = list.getEntryList().listIterator();
        this.mRunningList = true;
        this.run();
        this.current_entry_list = prev_entry_list;
        this.current_iterator = prev_iterator;
        this.mRunningList = prev_flag;
    }

    public void fireEvent(String event_name) {
        this.fireEvent(event_name, null);
    }

    public void fireEvent(String event_name, Object[] parameters) {
        Configuration config = this.getConfiguration();
        if (config == null) {
            return;
        }
        this.current_event = event_name;
        try {
            config.fireEvent(event_name, parameters, this, config.getHandleManager());
        }
        catch (Exception ex) {
            this.throwException(ex);
        }
    }

    public String getCurrentEvent() {
        return this.current_event;
    }

    public int getCurrentSequence() {
        return this.current_event_sequence;
    }

    public ProcedureRunner spawn(Procedure proc) {
        ProcedureRunner child = new ProcedureRunner();
        child.setProcedure(proc);
        child.mCaller = this;
        child.setContext(this.mContext);
        child.mRuntimeContext = this.mRuntimeContext;
        child.mUncertainEngine = this.mUncertainEngine;
        child.mLogger = this.mLogger;
        child.mSaveStackTrace = this.mSaveStackTrace;
        child.reset();
        return child;
    }

    public void call(Procedure another) {
        ProcedureRunner newRunner = this.spawn(another);
        newRunner.run();
        if (newRunner.getException() != null) {
            this.throwException(newRunner.getException());
        }
    }

    private void createDefaultConfig() {
        Configuration config = this.getConfiguration();
        if (config == null) {
            config = this.mUncertainEngine != null ? this.mUncertainEngine.createConfig() : new Configuration();
            this.setConfiguration(config);
        }
    }

    public void setConfiguration(Configuration config) {
        this.mRuntimeContext.setConfig(config);
    }

    public Configuration getConfiguration() {
        return this.mRuntimeContext == null ? null : this.mRuntimeContext.getConfig();
    }

    public void addConfiguration(Configuration procConfig) {
        Configuration config = this.getConfiguration();
        if (config == null) {
            this.setConfiguration(procConfig);
        } else {
            config.addConfiguration(procConfig);
        }
    }

    public UncertainEngine getUncertainEngine() {
        return this.mUncertainEngine;
    }

    public void setUncertainEngine(UncertainEngine uncertainEngine) {
        this.mUncertainEngine = uncertainEngine;
        this.createDefaultConfig();
    }

    public void setContextField(String name, Object value) {
        Field field = this.mProcedure.getField(name);
        if (field == null) {
            throw new IllegalArgumentException("Field " + name + " is not defined in procedure");
        }
        this.mContext.putObject(field.getPath(), value, true);
    }

    public Object getContextField(String name) {
        Field field = this.mProcedure.getField(name);
        if (field == null) {
            throw new IllegalArgumentException("Field " + name + " is not defined in procedure");
        }
        return this.mContext.getObject(field.getName());
    }

    public void transferContextFields(Collection fields, boolean write_to_participant) throws Exception {
        List participants;
        Configuration config = this.getConfiguration();
        List list = participants = config == null ? null : config.getParticipantList();
        if (participants == null) {
            return;
        }
        OCManager oc_manager = this.mUncertainEngine == null ? OCManager.getInstance() : this.mUncertainEngine.getOcManager();
        for (Field field : fields) {
            String name = field.getName();
            if (write_to_participant) {
                Object value = this.mContext.getObject(field.getPath());
                if (value == null) continue;
                for (Object participant : participants) {
                    oc_manager.setAttribute(participant, name, value);
                }
                continue;
            }
            for (Object participant : participants) {
                Object value = oc_manager.getAttribute(participant, name);
                if (value == null) continue;
                this.mContext.putObject(field.getPath(), value, true);
            }
        }
    }

    public ILogger getLogger() {
        if (this.mCaller != null) {
            return this.mCaller.getLogger();
        }
        if (this.mLogger != null) {
            return this.mLogger;
        }
        ILogger logger = (ILogger)this.mRuntimeContext.getInstanceOfType(ILogger.class);
        if (logger == null) {
            ILoggerProvider provider = (ILoggerProvider)this.mRuntimeContext.getInstanceOfType(ILoggerProvider.class);
            if (provider != null) {
                return provider.getLogger(LOGGING_TOPIC);
            }
            return DummyLogger.getInstance();
        }
        return logger;
    }

    public void setLogger(ILogger logger) {
        this.mLogger = logger;
    }

    public Throwable getLatestException() {
        return this.lastException;
    }

    public StackTraceManager getStackTraceManager() {
        return this.mStackTraceManager;
    }

    public void setSaveStackTrace(boolean flag) {
        this.mSaveStackTrace = flag;
    }
}

