/*
 * Decompiled with CFR 0.152.
 */
package uncertain.schema;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import uncertain.composite.QualifiedName;
import uncertain.schema.AbstractCategorized;
import uncertain.schema.Array;
import uncertain.schema.Attribute;
import uncertain.schema.Element;
import uncertain.schema.Extension;
import uncertain.schema.FeatureClass;
import uncertain.schema.IQualifiedNameResolver;
import uncertain.schema.IReference;
import uncertain.schema.ISchemaManager;
import uncertain.schema.ISchemaObject;
import uncertain.schema.IType;
import uncertain.schema.IValidator;
import uncertain.schema.NamedObjectManager;
import uncertain.schema.Schema;
import uncertain.schema.SchemaError;

public class ComplexType
extends AbstractCategorized
implements IType {
    Attribute[] mAttributes;
    Element[] mElements;
    Extension[] mExtensions;
    Array[] mArrays;
    IValidator[] mValidators;
    FeatureClass[] mClasses;
    NamedObjectManager mObjectManager = new NamedObjectManager();
    Schema mSchema;

    public boolean isComplex() {
        return true;
    }

    public IValidator[] getValidators() {
        return this.mValidators;
    }

    public void setValidators(IValidator[] validators) {
        this.mValidators = validators;
    }

    public Attribute[] getAttributes() {
        return this.mAttributes;
    }

    public void setAttributes(Attribute[] attributes) {
        this.mAttributes = attributes;
        this.addChilds(attributes);
    }

    public Element[] getElements() {
        return this.mElements;
    }

    public void setElements(Element[] elements) {
        this.mElements = elements;
        this.addChilds(elements);
    }

    public Extension[] getExtensions() {
        return this.mExtensions;
    }

    public void setExtensions(Extension[] extensions) {
        this.mExtensions = extensions;
        this.addChilds(extensions);
    }

    public boolean isExtensionOf(IType another) {
        return this.getAllExtendedTypes() != null && this.getAllExtendedTypes().contains(another);
    }

    public List getAllExtendedTypes() {
        ComplexType[] extended_types = this.loadSuperTypes();
        HashSet<QualifiedName> map = new HashSet<QualifiedName>();
        LinkedList<ComplexType> result = new LinkedList<ComplexType>();
        if (extended_types == null) {
            return null;
        }
        int i = 0;
        while (i < extended_types.length) {
            ComplexType t = extended_types[i];
            QualifiedName qname = t.getQName();
            if (!map.contains(qname)) {
                map.add(qname);
                result.add(t);
                this.addSuperElements(t);
            }
            ++i;
        }
        i = 0;
        while (i < extended_types.length) {
            List super_type = extended_types[i].getAllExtendedTypes();
            if (super_type != null) {
                for (ComplexType st : super_type) {
                    if (map.contains(st.getQName())) continue;
                    map.add(st.getQName());
                    result.add(st);
                    this.addSuperElements(st);
                }
            }
            ++i;
        }
        return result;
    }

    private void addSuperElements(ComplexType ct) {
        Array[] arrays;
        Element[] elements = ct.getElements();
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                Element ele = elements[i];
                if (this.mObjectManager.getElement(ele.getQName()) == null) {
                    this.mObjectManager.addElements(new Element[]{ele});
                }
                ++i;
            }
        }
        if ((arrays = ct.getArrays()) != null) {
            int i = 0;
            while (i < arrays.length) {
                Array arr = arrays[i];
                if (this.mObjectManager.getElement(arr.getQName()) == null) {
                    this.mObjectManager.addElements(new Array[]{arr});
                }
                ++i;
            }
        }
    }

    private ISchemaObject[] getChildArray(String type) {
        if ("attribute".equals(type)) {
            return this.mAttributes;
        }
        if ("element".equals(type)) {
            return this.mElements;
        }
        if ("array".equals(type)) {
            return this.mArrays;
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    private void addObjectToList(List list, ISchemaObject[] array) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                ISchemaObject obj = array[i];
                if (obj instanceof IReference) {
                    IReference ref = (IReference)((Object)obj);
                    if (ref.isRef()) {
                        list.add(ref.getRefObject());
                    } else {
                        list.add(obj);
                    }
                } else {
                    list.add(obj);
                }
                ++i;
            }
        }
    }

    protected List getAllChilds(String type) {
        LinkedList result = new LinkedList();
        this.addObjectToList(result, this.getChildArray(type));
        List types = this.getAllExtendedTypes();
        if (types != null) {
            for (ComplexType t : types) {
                this.addObjectToList(result, t.getChildArray(type));
            }
        }
        return result;
    }

    public List getAllAttributes() {
        return this.getAllChilds("attribute");
    }

    public List getAllElements() {
        return this.getAllChilds("element");
    }

    public List getAllArrays() {
        return this.getAllChilds("array");
    }

    protected ComplexType[] loadSuperTypes() {
        if (this.mExtensions == null) {
            return null;
        }
        if (this.mExtensions.length == 0) {
            return null;
        }
        ComplexType[] super_types = new ComplexType[this.mExtensions.length];
        int c = 0;
        int i = this.mExtensions.length - 1;
        while (i >= 0) {
            Extension extension = this.mExtensions[i];
            QualifiedName qname = extension.getBaseType();
            if (qname == null) {
                throw new SchemaError("Unknown namespace in qualified name:'" + extension.getBase() + "'");
            }
            ComplexType t = this.mSchema.getSchemaManager().getComplexType(qname);
            if (t == null) {
                throw new SchemaError("Unknown type:" + extension.getBase());
            }
            super_types[c++] = t;
            --i;
        }
        return super_types;
    }

    public void doAssemble() {
        super.doAssemble();
        this.mSchema = this.getSchema();
        this.mObjectManager.addAttributes(this.mAttributes);
        this.mObjectManager.addElements(this.mElements);
        this.mObjectManager.addElements(this.mArrays);
    }

    public void clearCache() {
        this.doAssemble();
    }

    public FeatureClass[] getClasses() {
        return this.mClasses;
    }

    public void setClasses(FeatureClass[] classes) {
        this.mClasses = classes;
    }

    public List getAttachedClasses() {
        LinkedList<Class> list = new LinkedList<Class>();
        if (this.mClasses != null) {
            int i = 0;
            while (i < this.mClasses.length) {
                list.add(this.mClasses[i].getType());
                ++i;
            }
        }
        return list;
    }

    private static void addList(Set set, List list, Object o) {
        if (set.contains(o)) {
            return;
        }
        set.add(o);
        list.add(o);
    }

    private static void addListAll(Set set, List list, Collection data) {
        Iterator it = data.iterator();
        while (it.hasNext()) {
            ComplexType.addList(set, list, it.next());
        }
    }

    public List getAllAttachedClasses() {
        LinkedList result = new LinkedList();
        List types = this.getAllExtendedTypes();
        HashSet all_classes = new HashSet();
        if (types != null) {
            ListIterator it = types.listIterator(types.size());
            while (it.hasPrevious()) {
                ComplexType t = (ComplexType)it.previous();
                ComplexType.addListAll(all_classes, result, t.getAllAttachedClasses());
            }
        }
        ComplexType.addListAll(all_classes, result, this.getAttachedClasses());
        return result;
    }

    public String toString() {
        QualifiedName qname = this.getQName();
        if (qname != null) {
            return qname.toString();
        }
        return "complexType";
    }

    public void resolveQName(IQualifiedNameResolver resolver) {
        super.resolveQName(resolver);
    }

    public Element getElement(QualifiedName qname) {
        Element elm = this.mObjectManager.getElement(qname);
        return elm;
    }

    public Attribute getAttribute(QualifiedName qname) {
        return this.mObjectManager.getAttribute(qname);
    }

    public Array[] getArrays() {
        return this.mArrays;
    }

    public void setArrays(Array[] arrays) {
        this.mArrays = arrays;
        this.addChilds(arrays);
    }

    public Array getArray(QualifiedName qname) {
        return this.mObjectManager.getArray(qname);
    }

    public void resolveReference(ISchemaManager manager) {
        super.resolveReference(manager);
        this.mObjectManager.resolveReference(manager);
    }
}

