/*
 * Decompiled with CFR 0.152.
 */
package uncertain.schema;

import java.util.ArrayList;
import java.util.List;
import uncertain.composite.QualifiedName;
import uncertain.schema.ComplexType;
import uncertain.schema.IQualifiedNameResolver;
import uncertain.schema.IReference;
import uncertain.schema.ISchemaManager;
import uncertain.schema.ISchemaObject;
import uncertain.schema.IType;
import uncertain.schema.InvalidQNameError;
import uncertain.schema.Schema;
import uncertain.schema.SchemaError;

public class Element
extends ComplexType
implements IReference {
    String mRef;
    String mUsage;
    String mType;
    String mDefault;
    String mMaxOccurs;
    String mMinOccurs;
    String mEditor;
    boolean mIsRef = false;
    ComplexType mRefType;
    IType mElementType;
    String mDisplayMask;
    String mDocument;
    String mWizard;
    QualifiedName mWizardQName;

    public String getDocument() {
        return this.mDocument;
    }

    public void setDocument(String document) {
        this.mDocument = document;
    }

    public String getDisplayMask() {
        return this.mDisplayMask;
    }

    public void setDisplayMask(String displayMask) {
        this.mDisplayMask = displayMask;
    }

    public String getRef() {
        return this.mRef;
    }

    public void setRef(String ref) {
        this.mRef = ref;
        this.mIsRef = this.mRef != null;
    }

    public ComplexType getRefType() {
        return this.mRefType;
    }

    public void doAssemble() {
        super.doAssemble();
    }

    public boolean isArray() {
        return false;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public IType getElementType() {
        Schema schema = this.getSchema();
        QualifiedName qname = schema.getQualifiedName(this.mType);
        return this.getSchemaManager().getType(qname);
    }

    public boolean isRef() {
        return this.mIsRef;
    }

    public QualifiedName getRefQName() {
        return this.mQname;
    }

    public ISchemaObject getRefObject() {
        if (this.mIsRef) {
            return this.mRefType;
        }
        return null;
    }

    public void resolveReference(ISchemaManager manager) {
        if (this.mIsRef) {
            this.mRefType = manager.getComplexType(this.mQname);
            if (this.mRefType == null) {
                throw new SchemaError("Unresolvable element ref:" + this.mRef);
            }
        }
        if (this.mType != null) {
            QualifiedName type_qname = this.getSchema().getQualifiedName(this.mType);
            if (type_qname == null) {
                throw new InvalidQNameError(this.mType);
            }
            this.mElementType = manager.getType(type_qname);
        }
        super.resolveReference(manager);
    }

    public void resolveQName(IQualifiedNameResolver resolver) {
        if (this.mIsRef) {
            this.mQname = resolver.getQualifiedName(this.mRef);
            if (this.mQname == null) {
                throw new SchemaError("Can't resolve ref qualified name:" + this.mRef);
            }
        } else {
            super.resolveQName(resolver);
        }
        if (this.mWizard != null && !this.mWizard.equals("")) {
            this.mWizardQName = resolver.getQualifiedName(this.mWizard);
            if (this.mWizardQName == null) {
                throw new SchemaError("Can't resolve wizard qualified name:" + this.mWizard);
            }
        }
    }

    public String getEditor() {
        return this.mEditor;
    }

    public void setEditor(String editor) {
        this.mEditor = editor;
    }

    public String getDefault() {
        return this.mDefault;
    }

    public void setDefault(String default1) {
        this.mDefault = default1;
    }

    public String getMaxOccurs() {
        return this.mMaxOccurs;
    }

    public void setMaxOccurs(String maxOccurs) {
        this.mMaxOccurs = maxOccurs;
    }

    public String getMinOccurs() {
        return this.mMinOccurs;
    }

    public void setMinOccurs(String minOccurs) {
        this.mMinOccurs = minOccurs;
    }

    public List getChildElements(ISchemaManager manager) {
        ArrayList<ComplexType> childElements = new ArrayList<ComplexType>();
        List childList = this.getAllElements();
        for (Object ele : childList) {
            ComplexType ele_ct = (ComplexType)ele;
            if (ele_ct instanceof Element) {
                childElements.add(ele_ct);
                continue;
            }
            childElements.addAll(manager.getElementsOfType(ele_ct));
        }
        return childElements;
    }

    public String getWizard() {
        return this.mWizard;
    }

    public void setWizard(String wizard) {
        this.mWizard = wizard;
    }

    public QualifiedName getWizardQName() {
        return this.mWizardQName;
    }

    public void setWizardQName(QualifiedName wizardQName) {
        this.mWizardQName = wizardQName;
    }
}

