/*
 * Decompiled with CFR 0.152.
 */
package uncertain.schema;

import java.util.HashMap;
import java.util.Map;
import uncertain.composite.QualifiedName;
import uncertain.schema.AbstractSchemaObject;
import uncertain.schema.Attribute;
import uncertain.schema.Category;
import uncertain.schema.ComplexType;
import uncertain.schema.Editor;
import uncertain.schema.Element;
import uncertain.schema.IQualifiedNameResolver;
import uncertain.schema.IQualifiedNamed;
import uncertain.schema.ISchemaManager;
import uncertain.schema.ISchemaObject;
import uncertain.schema.IType;
import uncertain.schema.NamedObjectManager;
import uncertain.schema.Namespace;
import uncertain.schema.SimpleType;
import uncertain.schema.Wizard;

public class Schema
extends AbstractSchemaObject
implements IQualifiedNameResolver {
    Namespace[] mNameSpaces;
    IType[] mTypes;
    Attribute[] mAttributes;
    Element[] mElements;
    Category[] mCategories;
    Editor[] mEditors;
    Wizard[] mWizards;
    String mTargetNamespace;
    ISchemaManager mSchemaManager;
    NamedObjectManager mNamedObjectManager;
    Map mNameSpaceMap = new HashMap();

    public Schema() {
        this.mNamedObjectManager = new NamedObjectManager();
    }

    protected void addChildArray(IQualifiedNamed[] childs, int map_index) {
        int i = 0;
        while (i < childs.length) {
            this.addChild(childs[i]);
            this.mNamedObjectManager.addNamedObject(map_index, childs[i]);
            ++i;
        }
    }

    public Namespace[] getNameSpaces() {
        return this.mNameSpaces;
    }

    public void addNameSpaces(Namespace[] nameSpaces) {
        this.mNameSpaces = nameSpaces;
        int i = 0;
        while (i < this.mNameSpaces.length) {
            this.mNameSpaceMap.put(this.mNameSpaces[i].getPrefix(), this.mNameSpaces[i]);
            this.addChild(this.mNameSpaces[i]);
            ++i;
        }
    }

    public IType[] getTypes() {
        return this.mTypes;
    }

    public void addTypes(IType[] types) {
        this.mTypes = types;
        this.addChildArray(types, 0);
    }

    public Attribute[] getAttributes() {
        return this.mAttributes;
    }

    public void addAttributes(Attribute[] attributes) {
        this.mAttributes = attributes;
        this.addChildArray(attributes, 1);
    }

    public Element[] getElements() {
        return this.mElements;
    }

    public void addElements(Element[] elements) {
        this.mElements = elements;
        this.addChildArray(elements, 0);
    }

    public Category[] getCategories() {
        return this.mCategories;
    }

    public void addCategories(Category[] categories) {
        this.mCategories = categories;
        this.addChildArray(categories, 2);
    }

    public Editor[] geEditors() {
        return this.mEditors;
    }

    public void addEditors(Editor[] Editors) {
        this.mEditors = Editors;
        this.addChildArray(Editors, 3);
    }

    public Wizard[] geWizards() {
        return this.mWizards;
    }

    public void addWizards(Wizard[] Wizards) {
        this.mWizards = Wizards;
        this.addChildArray(Wizards, 4);
    }

    public String getTargetNamespace() {
        return this.mTargetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.mTargetNamespace = targetNamespace;
    }

    public Namespace getNamespace(String prefix) {
        Namespace ns = (Namespace)this.mNameSpaceMap.get(prefix);
        return ns;
    }

    public QualifiedName getQualifiedName(String prefix, String name) {
        assert (name != null);
        if (prefix == null) {
            return new QualifiedName(null, null, name);
        }
        Namespace ns = (Namespace)this.mNameSpaceMap.get(prefix);
        if (ns == null) {
            return null;
        }
        return new QualifiedName(ns.getPrefix(), ns.getUrl(), name);
    }

    public QualifiedName getQualifiedName(String name) {
        assert (name != null);
        int index = name.indexOf(58);
        if (index < 0) {
            return this.getQualifiedName(null, name);
        }
        String prefix = name.substring(0, index);
        String element_name = name.substring(index + 1, name.length());
        return this.getQualifiedName(prefix, element_name);
    }

    public void setSchemaManager(ISchemaManager schemaManager) {
        this.mSchemaManager = schemaManager;
    }

    public ISchemaManager getSchemaManager() {
        return this.mSchemaManager;
    }

    public Schema getSchema() {
        return this;
    }

    public Attribute getAttribute(QualifiedName qname) {
        Attribute attrib = this.mNamedObjectManager.getAttribute(qname);
        return attrib;
    }

    public Element getElement(QualifiedName qname) {
        return this.mNamedObjectManager.getElement(qname);
    }

    public ComplexType getComplexType(QualifiedName qname) {
        return this.mNamedObjectManager.getComplexType(qname);
    }

    public SimpleType getSimpleType(QualifiedName qname) {
        return this.mNamedObjectManager.getSimpleType(qname);
    }

    public IType getType(QualifiedName qname) {
        return this.mNamedObjectManager.getType(qname);
    }

    public Map getTypeMap() {
        return this.mNamedObjectManager.getObjectMap(0);
    }

    public void addChild(ISchemaObject child) {
        super.addChild(child);
        if (child instanceof IQualifiedNamed) {
            ((IQualifiedNamed)child).resolveQName(this);
        }
    }

    public void resolveReference() {
        this.mNamedObjectManager.resolveReference(this.mSchemaManager);
    }
}

